unit ftptrans;

interface

uses
  WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Gauges;

type
  TTransferForm = class(TForm)
    CancelButton: TButton;
    Label1: TLabel;
    ProgressBar: TGauge;
    procedure CancelButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure ShowProgress(Received, Total : LongInt);
  end;

var
  TransferForm: TTransferForm;

implementation

{$R *.DFM}

uses
  FtpMain;

procedure TTransferForm.ShowProgress(Received, Total : LongInt);
begin
  Label1.Caption:=IntToStr(Received)+' of '+IntToStr(Total)+
    ' bytes transferred...';
  if Total<>0 then
    ProgressBar.Progress:=Round(100*Received/Total)
  else
    ProgressBar.Progress:=0;
end;

procedure TTransferForm.CancelButtonClick(Sender: TObject);
begin
  Hide;
  FTPForm.agFTP1.AbortTransfer;
end;

end.
